import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  CreateDateColumn,
  UpdateDateColumn,
  ManyToOne,
  JoinColumn,
  DeleteDateColumn,
  OneToMany,
} from 'typeorm';
import { OptionType } from '../enum/option-type.enum';
import { OptionCategory } from './option-category.entity';
import { User } from './user.entity';
import { QuestionOptionMap } from './question-option.entity';
import { CommonStatus } from '../enum/common-status.enum';

@Entity('hdb_option')
export class Option {
  @PrimaryGeneratedColumn({ name: 'id' })
  id: number;

  @Column({ name: 'name', type: 'varchar', length: 255, nullable: false })
  name: string;

  @Column({ name: 'typ', type: 'enum', enum: OptionType, nullable: false })
  type: OptionType;

  @Column({ name: 'category_id', type: 'int', nullable: true })
  categoryId: number | null;

  @CreateDateColumn({ name: 'created_at', type: 'timestamptz', default: () => 'CURRENT_TIMESTAMP' })
  createdAt: Date;

  @UpdateDateColumn({ name: 'updated_at', type: 'timestamptz', default: () => 'CURRENT_TIMESTAMP', onUpdate: 'CURRENT_TIMESTAMP' })
  updatedAt: Date;

  @DeleteDateColumn({ name: 'deleted_at', type: 'timestamptz', nullable: true, default: null })
  deletedAt: Date;

  @Column({ name: 'stats', type: 'enum', enum: CommonStatus, default: 'draft' })
  status: string;


  @ManyToOne(() => OptionCategory, { nullable: true, onDelete: 'CASCADE' })
  @JoinColumn({ name: 'category_id' })
  category: OptionCategory;

  @ManyToOne(() => User, { nullable: true, onDelete: 'SET NULL' })
  @JoinColumn({ name: 'created_by' })
  createdBy: User;

  @ManyToOne(() => User, { nullable: true, onDelete: 'SET NULL' })
  @JoinColumn({ name: 'updated_by' })
  updatedBy: User;

  @OneToMany(() => QuestionOptionMap, (questionOptionMap) => questionOptionMap.option)
  questionOptionMaps: QuestionOptionMap[];

  constructor(partial: Partial<Option>) {
    Object.assign(this, partial);
  }
}