import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  CreateDateColumn,
  UpdateDateColumn,
  DeleteDateColumn,
} from 'typeorm';
import { CommonStatus } from '../enum/common-status.enum';

@Entity('feature_flag')
export class FeatureFlag {
  @PrimaryGeneratedColumn('increment')
  id: number;

  @Column({ name: 'feature_key', type: 'varchar', length: 255, unique: true })
  key: string;

  @Column({ name: 'label', type: 'varchar', length: 255 })
  label: string;

  @Column({ name: 'description', type: 'varchar', length: 512, nullable: true })
  description?: string;

  @Column({ name: 'flag', type: 'boolean', default: false })
  flag: boolean;

  @Column({
    name: 'status',
    type: 'enum',
    enum: CommonStatus,
    default: CommonStatus.ACTIVE,
  })
  status: CommonStatus;

  @CreateDateColumn({ name: 'created_at', type: 'timestamptz', default: () => 'CURRENT_TIMESTAMP' })
  createdAt: Date;

  @UpdateDateColumn({ name: 'updated_at', type: 'timestamptz', default: () => 'CURRENT_TIMESTAMP', onUpdate: 'CURRENT_TIMESTAMP' })
  updatedAt: Date;

  @DeleteDateColumn({ name: 'deleted_at', type: 'timestamptz', nullable: true })
  deletedAt: Date;

  @Column({ name: 'created_by', type: 'int', nullable: true })
  createdBy: number;

  @Column({ name: 'updated_by', type: 'int', nullable: true })
  updatedBy: number;

  constructor(partial: Partial<FeatureFlag>) {
    Object.assign(this, partial);
  }
}
