import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  CreateDateColumn,
  Index,
  OneToMany,
} from 'typeorm';
import { AuditHistoryLogDetail } from './audit-history-log-detail.entity';
import { AuditHistoryLogType } from 'src/audit-history/audit-history.constants';

@Entity('audit_history_log')
@Index(['entityType', 'entityId'])
@Index(['userId'])
@Index(['createdAt'])
@Index(['parentRefId'])
export class AuditHistoryLog {
  @PrimaryGeneratedColumn()
  id: string;

  @Column({ name: 'entity_type', type: 'varchar', length: 100 })
  entityType: string;

  @Column({ name: 'entity_name', type: 'varchar', length: 100 })
  entityName: string;

  @Column({ name: 'entity_id', type: 'varchar', length: 100 })
  entityId: string;

  @Column({ name: 'action', type: 'varchar', length: 10 })
  action: string;

  @Column({ name: 'user_id', type: 'varchar', length: 100, nullable: true })
  userId: string | null;

  @Column({ name: 'ip_address', type: 'varchar', length: 45, nullable: true })
  ipAddress: string | null;

  @Column({ name: 'user_agent', type: 'varchar', length: 500, nullable: true })
  userAgent: string | null;

  @Column({ name: 'api_endpoint', type: 'varchar', length: 255, nullable: true })
  apiEndpoint: string | null;

  @Column({ name: 'http_method', type: 'varchar', length: 10, nullable: true })
  httpMethod: string | null;

  @Column({ name: 'request_id', type: 'varchar', length: 100, nullable: true })
  requestId: string | null;

  @Column({ name: 'parent_ref_id', type: 'varchar', length: 100, nullable: true })
  parentRefId: string | null;

  @Column({ name: 'metadata', type: 'jsonb', nullable: true })
  metadata: Record<string, any> | null;

  @Column({
    name: 'type',
    type: 'varchar',
    length: 10,
    default: AuditHistoryLogType.AUDIT,
  })
  type: AuditHistoryLogType;

  @CreateDateColumn({ name: 'created_at', type: 'timestamptz' })
  createdAt: Date;

  @OneToMany(() => AuditHistoryLogDetail, (detail) => detail.auditHistoryLog, {
    cascade: true,
  })
  details: AuditHistoryLogDetail[];
}
