import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  CreateDateColumn,
  UpdateDateColumn,
} from 'typeorm';
import { AddressTypeEnum } from '../enum/address-type.enum';

@Entity('hdb_address')
export class Address {
  @PrimaryGeneratedColumn({ name: 'address_id' })
  id: number;

  @Column({ name: 'location_id', type: 'int', nullable: true })
  locationId: number;

  @Column({ name: 'addr_1', type: 'varchar', length: 255, nullable: true })
  addr1: string;

  @Column({ name: 'addr_2', type: 'varchar', length: 255, nullable: true })
  addr2: string;

  @Column({ name: 'landmark', type: 'varchar', length: 255, nullable: true })
  landmark: string;

  @Column({ name: 'city', type: 'varchar', length: 100, nullable: true })
  city: string;

  @Column({ name: 'state', type: 'varchar', length: 100, nullable: true })
  state: string;

  @Column({ name: 'country', type: 'varchar', length: 100, nullable: true })
  country: string;

  @Column({ name: 'pincode', type: 'varchar', length: 20, nullable: true })
  pincode: string;

  @Column({ name: 'lat', type: 'numeric', precision: 9, scale: 6, nullable: true })
  lat: number;

  @Column({ name: 'long', type: 'numeric', precision: 9, scale: 6, nullable: true })
  long: number;

  @Column({ name: 'type', type: 'enum', enum: AddressTypeEnum })
  type: AddressTypeEnum;

  @CreateDateColumn({ name: 'created_at', type: 'timestamptz', default: () => 'CURRENT_TIMESTAMP' })
  createdAt: Date;

  @UpdateDateColumn({ name: 'updated_at', type: 'timestamptz', default: () => 'CURRENT_TIMESTAMP', onUpdate: 'CURRENT_TIMESTAMP' })
  updatedAt: Date;

  @Column({ name: 'created_by', type: 'varchar', length: 255, nullable: true })
  createdBy: string;

  @Column({ name: 'updated_by', type: 'varchar', length: 255, nullable: true })
  updatedBy: string;

  constructor(partial: Partial<Address>) {
    Object.assign(this, partial);
  }
}
