// constants.ts

import { CommunicationTemplatesKeysEnum } from "../enum/communication-template-keys.enum";
import { RoomStatus } from "../enums/room-status.enum";

export const MainProgramDimensions = ["programRegistration", "rating", "programBlessedSeekers", "programApprovalStatus", "detailedData", "demographics", 'preferredVsBlessed', 'goodiesData', 'goodiesTshirt', 'goodiesJacket'];
export const SubProgramDimensions = ['programRegistration',"payment", 'invoice', 'demographics', 'travelPlan', 'travelStatus', 'goodiesData', 'goodiesTshirt', 'goodiesJacket'];
export const RoleKPIs = {
    admin : ["programRegistration", "preferredVsBlessed", 'programApprovalStatus', 'programBlessedSeekers', 'demographics', 'loaction', 'invoice', 'detailedData', 'location', 'goodiesData', 'goodiesTshirt', 'goodiesJacket'],
    viewer : ["programRegistration", "preferredVsBlessed", 'programApprovalStatus', 'programBlessedSeekers', 'demographics', 'loaction', 'invoice', 'detailedData'],
    mahatria :["programRegistration", 'preferredVsBlessed', 'programApprovalStatus', 'programBlessedSeekers', 'demographics', 'loaction', 'invoice', 'detailedData', 'location'],
    rm : ["programRegistration", 'rating', 'preferredVsBlessed', 'programApprovalStatus', 'programBlessedSeekers', 'demographics',, 'invoice'],
    finance_manager : ["programRegistration", 'programApprovalStatus', 'programBlessedSeekers', 'demographics', 'invoice', 'detailedData'],
    relational_manager : ["programRegistration",'rating', 'preferredVsBlessed', 'programApprovalStatus', 'programBlessedSeekers', 'demographics', 'loaction', 'invoice','detailedData','goodiesData', 'goodiesTshirt', 'goodiesJacket'],
    shoba : ["programRegistration", 'preferredVsBlessed', 'programApprovalStatus', 'programBlessedSeekers', 'demographics', 'loaction', 'invoice', 'detailedData', 'location', 'goodiesData', 'goodiesTshirt', 'goodiesJacket'],
    operational_manger : ["programRegistration", 'preferredVsBlessed', 'programApprovalStatus', 'programBlessedSeekers', 'demographics', 'loaction', 'invoice', 'location', 'detailedData','goodiesData', 'goodiesTshirt', 'goodiesJacket'],
    rm_support : ["programRegistration", 'preferredVsBlessed', 'programApprovalStatus', 'programBlessedSeekers', 'demographics', 'loaction', 'invoice', 'location', 'detailedData','goodiesData', 'goodiesTshirt', 'goodiesJacket'],
}
export const MajorCities = ['Delhi', 'Hyderabad', 'Chennai', 'Bangalore', 'Pune', 'Mumbai'];
export const ONES = [
    '', 'One', 'Two', 'Three', 'Four', 'Five', 'Six',
    'Seven', 'Eight', 'Nine', 'Ten', 'Eleven', 'Twelve',
    'Thirteen', 'Fourteen', 'Fifteen', 'Sixteen',
    'Seventeen', 'Eighteen', 'Nineteen'
];
export  const TENS = ['', '', 'Twenty', 'Thirty', 'Forty', 'Fifty',
    'Sixty', 'Seventy', 'Eighty', 'Ninety'];
export const SEEKER_FE_REG_PATH = `myspace/programs/registration?programId=`;
export const SEEKER_FE_EDIT_REGISTRATION_PATH = `&isEdit=true`;

export const COMMUNICATION_TEMPLATE_NAMES_BY_KEYS = {
    [CommunicationTemplatesKeysEnum.FIRST_TIMER]: 'First Timer Email',
    [CommunicationTemplatesKeysEnum.CHECKLIST]: 'Checklist Email',
    [CommunicationTemplatesKeysEnum.PREPARATORY]: 'Preparatory Email',
};

export const USER_PROFILE_BINDING_KEYS = [
    'name',
    'city',
    'otherCityName',
    'gender',
    'profileUrl',
    'dob',
    'countryName',
    'mobileNumber',
    'email'
]


export const USER_PROFILE_EXTENSION_BINDING_KEYS = [
    'pictureUrl',
    'idBack',
    'invoiceEmail',
    'invoiceName',
    'pro_forma_invoice_name',
    'invoiceAddress',
    'proFormaBillingAddress',
    'tanNumber',
    'proFormaIsGstRegistered',
    'proFormaGstNumber',
    'gstNumber',
    'isGstRegistered',
    'QK_LAST_HDB',
    'QK_HDB_ASSOCIATION_SINCE',
    'no_of_hdbs',
    'whichOfTheFollowingHaveYouExperienced',
    'QK_HDB_SONG_1',
    'QK_HDB_SONG_2',
    'rmContact',
    'otherInfinitheismContact',
    'zip',
    'proFormaZip'
];

// Role-based report access matrix for Phase 1
export const REPORT_ACCESS_MATRIX = {
  all_seekers: ['relational_manager', 'finance_manager', 'operational_manger', 'rm_support', 'admin', 'mahatria', 'shoba'],
  registration_form_report: ['relational_manager', 'finance_manager', 'operational_manger', 'rm_support', 'admin', 'mahatria', 'shoba'],
  swap_can_shift_report: ['operational_manger', 'rm_support', 'admin', 'mahatria', 'shoba'],
  drafts_report: ['relational_manager', 'shoba', 'admin'],
  finance_report: ['finance_manager', 'admin'],
//   travel_report: ['relational_manager', 'operational_manger', 'rm_support', 'admin'],
//   master_list: ['admin', 'mahatria', 'shoba'],
  master_travel_and_goodies_report:['relational_manager', 'operational_manger', 'rm_support', 'admin', 'shoba', 'mahatria'],
  travel_onward_and_return_report: ['relational_manager', 'operational_manger', 'rm_support', 'admin', 'shoba', 'mahatria'],
  goodies_and_ratria_pillar_report: ['relational_manager', 'operational_manger', 'rm_support', 'admin', 'shoba', 'mahatria'],
  travel_onward_report: ['relational_manager', 'operational_manger', 'rm_support', 'admin', 'shoba', 'mahatria'],
  travel_return_report: ['relational_manager', 'operational_manger', 'rm_support', 'admin', 'shoba', 'mahatria'],
  payment_list: ['admin', 'mahatria', 'shoba'],
  birthday_list: ['admin', 'mahatria', 'shoba'],
  song_preferences_list: ['admin', 'mahatria', 'shoba'],
  hold_list: ['admin', 'mahatria', 'shoba'],
  confirmed_list: ['admin', 'mahatria', 'shoba']
};

export const REPORT_CODES  = [
  'all_seekers', 
  'registration_form_report', 
  'finance_report', 
  // 'travel_report', 
  // 'master_list', 
  'master_travel_and_goodies_report', 
  'payment_list', 
  'birthday_list', 
  'song_preferences_list', 
  'hold_list', 
  'confirmed_list',
  'travel_onward_and_return_report',
  'goodies_and_ratria_pillar_report',
  'travel_onward_report',
  'travel_return_report',
  'swap_can_shift_report'
];

export const ROOM_INVENTORY_REPORT_CODES = [
  'room_inventory_allocation_report'
];

// Room inventory download types
export const ROOM_INVENTORY_DOWNLOAD_TYPES = [
  'all',
  'filtered'
];

// Room inventory report access matrix
export const ROOM_INVENTORY_REPORT_ACCESS_MATRIX = {
  room_inventory_allocation_report: ['mahatria', 'shoba', 'operational_manger', 'rm_support', 'admin'],
};

// Room inventory report definitions
export const ROOM_INVENTORY_REPORT_DEFINITIONS = {
  room_inventory_allocation_report: {
    label: 'Room Inventory Allocation Report',
    description: 'Comprehensive report listing all rooms with their allocations and seeker details',
  }
};

// Airline code to full name mapping - used for travel reports
export const AIRLINE_CODE_TO_NAME = {
  'EK': 'Emirates',
  'EY': 'Etihad Airways',
  'QR': 'Qatar Airways',
  'SQ': 'Singapore Air',
  'I5': 'Air Asia',
  'AI': 'Air India',
  'G8': 'Go First',
  '6E': 'IndiGo',
  'SG': 'SpiceJet',
  'UK': 'Vistara',
  'IX': 'Air India Express',
  'QP': 'Akasa Air',
  '9I': 'Alliance Air',
  'S5': 'Star Air',
  'OTHER': 'Other'
};

export const citiesList = [
  { label: 'Agra', value: 'Agra' },
  { label: 'Ahmedabad', value: 'Ahmedabad' },
  { label: 'Ajmer', value: 'Ajmer' },
  { label: 'Aligarh', value: 'Aligarh' },
  { label: 'Allahabad', value: 'Allahabad' },
  { label: 'Ambattur', value: 'Ambattur' },
  { label: 'Amravati', value: 'Amravati' },
  { label: 'Amritsar', value: 'Amritsar' },
  { label: 'Asansol', value: 'Asansol' },
  { label: 'Aurangabad', value: 'Aurangabad' },
  { label: 'Bangalore', value: 'Bangalore' },
  { label: 'Bareilly', value: 'Bareilly' },
  { label: 'Belgaum', value: 'Belgaum' },
  { label: 'Bhavnagar', value: 'Bhavnagar' },
  { label: 'Bhilai Nagar', value: 'Bhilai Nagar' },
  { label: 'Bhiwandi', value: 'Bhiwandi' },
  { label: 'Bhopal', value: 'Bhopal' },
  { label: 'Bhubaneswar', value: 'Bhubaneswar' },
  { label: 'Bikaner', value: 'Bikaner' },
  { label: 'Chandigarh', value: 'Chandigarh' },
  { label: 'Chennai', value: 'Chennai' },
  { label: 'Coimbatore', value: 'Coimbatore' },
  { label: 'Cuttack', value: 'Cuttack' },
  { label: 'Dehradun', value: 'Dehradun' },
  { label: 'Delhi', value: 'Delhi' },
  { label: 'Dhanbad', value: 'Dhanbad' },
  { label: 'Durgapur', value: 'Durgapur' },
  { label: 'Faridabad', value: 'Faridabad' },
  { label: 'Firozabad', value: 'Firozabad' },
  { label: 'Gaya', value: 'Gaya' },
  { label: 'Ghaziabad', value: 'Ghaziabad' },
  { label: 'Gorakhpur', value: 'Gorakhpur' },
  { label: 'Gulbarga', value: 'Gulbarga' },
  { label: 'Guntur', value: 'Guntur' },
  { label: 'Gurgaon', value: 'Gurgaon' },
  { label: 'Guwahati', value: 'Guwahati' },
  { label: 'Gwalior', value: 'Gwalior' },
  { label: 'Haora', value: 'Haora' },
  { label: 'Hubli And Dharwad', value: 'Hubli And Dharwad' },
  { label: 'Hyderabad', value: 'Hyderabad' },
  { label: 'Indore', value: 'Indore' },
  { label: 'Jabalpur', value: 'Jabalpur' },
  { label: 'Jaipur', value: 'Jaipur' },
  { label: 'Jalandhar', value: 'Jalandhar' },
  { label: 'Jalgaon', value: 'Jalgaon' },
  { label: 'Jammu', value: 'Jammu' },
  { label: 'Jamnagar', value: 'Jamnagar' },
  { label: 'Jamshedpur', value: 'Jamshedpur' },
  { label: 'Jhansi', value: 'Jhansi' },
  { label: 'Jodhpur', value: 'Jodhpur' },
  { label: 'Kalyan & Dombivali', value: 'Kalyan & Dombivali' },
  { label: 'Kanpur', value: 'Kanpur' },
  { label: 'Kochi', value: 'Kochi' },
  { label: 'Kolapur', value: 'Kolapur' },
  { label: 'Kolkata', value: 'Kolkata' },
  { label: 'Kota', value: 'Kota' },
  { label: 'Loni', value: 'Loni' },
  { label: 'Lucknow', value: 'Lucknow' },
  { label: 'Ludhiana', value: 'Ludhiana' },
  { label: 'Madurai', value: 'Madurai' },
  { label: 'Maheshtala', value: 'Maheshtala' },
  { label: 'Malegaon', value: 'Malegaon' },
  { label: 'Mangalore', value: 'Mangalore' },
  { label: 'Meerut', value: 'Meerut' },
  { label: 'Mira And Bhayander', value: 'Mira And Bhayander' },
  { label: 'Moradabad', value: 'Moradabad' },
  { label: 'Mumbai', value: 'Mumbai' },
  { label: 'Nagpur', value: 'Nagpur' },
  { label: 'Nanded Waghala', value: 'Nanded Waghala' },
  { label: 'Nashik', value: 'Nashik' },
  { label: 'Navi Mumbai', value: 'Navi Mumbai' },
  { label: 'Nellore', value: 'Nellore' },
  { label: 'Noida', value: 'Noida' },
  { label: 'Patna', value: 'Patna' },
  { label: 'Pimpri & Chinchwad', value: 'Pimpri & Chinchwad' },
  { label: 'Pune', value: 'Pune' },
  { label: 'Raipur', value: 'Raipur' },
  { label: 'Rajkot', value: 'Rajkot' },
  { label: 'Ranchi', value: 'Ranchi' },
  { label: 'Saharanpur', value: 'Saharanpur' },
  { label: 'Salem', value: 'Salem' },
  { label: 'Sangli Miraj Kupwad', value: 'Sangli Miraj Kupwad' },
  { label: 'Siliguri', value: 'Siliguri' },
  { label: 'Solapur', value: 'Solapur' },
  { label: 'Srinagar', value: 'Srinagar' },
  { label: 'Surat', value: 'Surat' },
  { label: 'Thane', value: 'Thane' },
  { label: 'Thiruvananthapuram', value: 'Thiruvananthapuram' },
  { label: 'Tiruchirappalli', value: 'Tiruchirappalli' },
  { label: 'Tirunelveli', value: 'Tirunelveli' },
  { label: 'Udaipur', value: 'Udaipur' },
  { label: 'Ujjain', value: 'Ujjain' },
  { label: 'Ulhasnagar', value: 'Ulhasnagar' },
  { label: 'Vadodara', value: 'Vadodara' },
  { label: 'Varanasi', value: 'Varanasi' },
  { label: 'Vasai Virar', value: 'Vasai Virar' },
  { label: 'Vijayawada', value: 'Vijayawada' },
  { label: 'Visakhapatnam', value: 'Visakhapatnam' },
  { label: 'Warangal', value: 'Warangal' },
  { label: 'Other', value: 'Other' },
];

export const allowedRolesForRMFilter = ['operational_manger', 'rm_support', 'mahatria' , 'admin', 'shoba'];

export const allowedRolesForExperienceTags = ['operational_manger', 'rm_support', 'mahatria' , 'admin', 'shoba', 'relational_manager'];

export const phoneNumberType = {
    differentNumber : "Family member's number",
    myPhoneNumber : "My phone number"
};

// Registration question binding keys
export const REGISTRATION_BINDING_KEYS = {
    TRAVEL_PLAN_RETURN: 'travelPlanReturn',
    TRAVEL_PLAN_ONWARD: 'travelPlanOnward',
    TRAVEL_DETAILS: 'travelDetails',  
};

export const LOOKUP_CATEGORY = {
    SEEKER_PROGRAM_EXPERIENCE: 'SEEKER_PROGRAM_EXPERIENCE',
};

export const specialLookupKeys = ['HDB', 'MSD', 'ENTRAINMENT_25', 'TAT_2025'];

/**
 * Constants related to Goodies functionality
 */

// Display values for goodies selection
export const GOODIES_DISPLAY_VALUES = {
  NO: 'No',
  YES: 'Yes',
  EMPTY: '',
  DASH: '-',
  NULL: 'null',
  UNDEFINED: 'undefined',
} as const;

// Size order constants for sorting
export const SIZE_ORDER = {
  NO: 1,
  XS: 2,
  S: 3,
  M: 4,
  L: 5,
  XL: 6,
  XXL: 7,
  XXXL: 8,
  YES: 9,
  UNKNOWN: 999,
} as const;

// Size values (lowercase for comparison)
export const SIZE_VALUES = {
  NO: 'no',
  XS: 'xs',
  S: 's',
  M: 'm',
  L: 'l',
  XL: 'xl',
  XXL: 'xxl',
  XXXL: 'xxxl',
  YES: 'yes',
} as const;

// Ratria Pillar order constants for sorting
export const RATRIA_PILLAR_ORDER = {
  NO: 1,
  LEONIA: 2,
  OTHER_LOCATIONS: 250,
  YES: 500,
  UNKNOWN: 999,
} as const;

// Ratria Pillar location values (lowercase for comparison)
export const RATRIA_PILLAR_VALUES = {
  NO: 'no',
  LEONIA: 'leonia',
  YES: 'yes',
} as const;

// Empty value identifiers
export const EMPTY_VALUE_IDENTIFIERS = [
  '',
  '-',
  'null',
  'undefined',
] as const;

// Sort field identifiers for goodies
export const GOODIES_SORT_FIELDS = {
  GOODIES_STATUS: 'goodies.goodiesStatus',
  FLASK: 'goodies.flask',
  NOTEBOOK: 'goodies.notebook',
  RATRIA_PILLARS: 'goodies.ratriaPillars',
  JACKET: 'goodies.jacket',
  TSHIRT: 'goodies.tshirt',
} as const;

// Goodies status messages
export const STATUS_MESSAGES = {
  PENDING: 'Pending',
  COMPLETED: 'Completed',
  DASH: '-',
} as const;


/**
 * Mapping of question binding keys to their corresponding signed URL columns
 * These mappings are used to store signed S3 URLs for file upload questions
 */
export const SIGNED_URL_COLUMN_MAPPINGS = {
  // Profile URL mapping
  profileUrl: {
    plainUrlColumn: 'user_profile_url',
    signedUrlColumn: 'user_profile_signed_url',
    tableName: 'hdb_program_registration',
  },
  
  // Video URL mapping
  videoUrl: {
    plainUrlColumn: 'user_video_url',
    signedUrlColumn: 'user_video_signed_url',
    tableName: 'hdb_program_registration',
  },
  
  // ID Back picture URL mapping
  idBack: {
    plainUrlColumn: 'id_back_picture_url',
    signedUrlColumn: 'id_back_picture_signed_url',
    tableName: 'hdb_registration_travel_info',
  },
  
  // Passport copy URL mapping
  passport: {
    plainUrlColumn: 'passport_copy_picture_url',
    signedUrlColumn: 'passport_copy_picture_signed_url',
    tableName: 'hdb_registration_travel_info',
  },
  
  // Upload onward journey ticket mapping
  uploadOnwardJourneyTicket: {
    plainUrlColumn: 'onward_journey_ticket_url',
    signedUrlColumn: 'onward_journey_ticket_signed_url',
    tableName: 'hdb_registration_travel_plan',
  },
  
  // Upload return journey ticket mapping
  uploadReturnJourneyTicket: {
    plainUrlColumn: 'return_journey_ticket_url',
    signedUrlColumn: 'return_journey_ticket_signed_url',
    tableName: 'hdb_registration_travel_plan',
  },
  
  // ID picture (Front / Front+Back) URL mapping
  pictureUrl: {
    plainUrlColumn: 'id_picture_url',
    signedUrlColumn: 'id_picture_signed_url',
    tableName: 'hdb_registration_travel_info',
  },
  
  // VISA copy URL mapping
  visa: {
    plainUrlColumn: 'visa_copy_picture_url',
    signedUrlColumn: 'visa_copy_picture_signed_url',
    tableName: 'hdb_registration_travel_info',
  },
};

/**
 * Domains that should be excluded from signed URL generation
 * URLs containing these domains will use the plain URL directly
 */
export const SIGNED_URL_EXCLUDED_DOMAINS = ['zoho', 'entrainment'];

export const CRON_CONSTANTS = {
  SIGNED_URLS_SCHEDULED_CRON: '0 23 * * 0' // Every Sunday at 11:00 PM
};

export const FEATURE_FLAG_KEYS = {
  SEND_PAYMENT_REMINDERS_TO_RM: 'sendPaymentRemindereToRM',
  SHOW_INFINIPATH: 'showInfinipath',
  SHOW_INFINIMINUTE_PRAYER: 'showInfiniminutePrayer',
};

  // Constants for KPI categories
  export const KPI_CATEGORIES = {
    REGISTRATIONS: 'registrations',
    PROGRAMS: 'programs',
    BLESSED: 'blessed',
    ALLOCATED: 'allocated',
    SWAP_DEMAND: 'swapDemand',
    SWAP_REQUESTS: 'swapRequests',
    UNALLOCATED: 'unallocated',
    ALL: 'all',
    CANCELLED: 'cancelled',
    REG_PENDING: 'regPending',
    HDB: 'HDB', 
  } as const;

  // Constants for KPI filters
  export const KPI_FILTERS = {
    APPROVED_SEEKERS: 'approvedSeekers',
    CANCELLED: 'cancelled',
    REJECTED: 'rejected',
    ON_HOLD: 'onHold',
    NEW_SEEKERS_PENDING: 'newSeekersPending',
    SWAP_REQUESTS: 'swapRequests',
    SWAP_REQUEST_HYPEN: 'swap-requests',
    REJECT: 'reject',
    HOLD: 'hold',
    BLESSED: 'blessed',
    REG_PENDING: 'regPending',
    ALL: 'all',
  } as const;

  // Constants for sort orders
  export const SORT_ORDER = {
    ASC: 'ASC' as const,
    DESC: 'DESC' as const
  };

/**
 * Room Allocation Filter Configuration Constants
 */

// Age filter options for room allocation filtering
export const ROOM_ALLOCATION_AGE_FILTER_OPTIONS = [
  { label: '<=20 years', value: { min: 0, max: 20 } },
  { label: '21-30 years', value: { min: 21, max: 30 } },
  { label: '31-50 years', value: { min: 31, max: 50 } },
  { label: '51-65 years', value: { min: 51, max: 65 } },
  { label: '>65 years', value: { min: 66 } },
] as const;

// Gender filter options for room allocation filtering
export const ROOM_ALLOCATION_GENDER_FILTER_OPTIONS = [
  { label: 'Male', value: 'male' },
  { label: 'Female', value: 'female' },
] as const;

// HDB filter options for room allocation filtering
export const ROOM_ALLOCATION_HDB_FILTER_OPTIONS =  [
  { label: 'Equals', value: { eq: 0 } },
  { label: 'Greater than', value: { minExcluded: 10 } },
  { label: 'Less than', value: { maxExcluded: 11 } },
  { label: 'Within a range', value: { min: 1, max: 10 } },
] as const;

// Roommate preference options for room allocation filtering
export const ROOM_ALLOCATION_ROOMMATE_PREFERENCE_OPTIONS = [
  { label: 'Yes', value: 'yes' },
  { label: 'No', value: 'no' }
] as const;

// Paired status options for room allocation filtering
export const ROOM_ALLOCATION_PAIRED_STATUS_OPTIONS = [
  { label: 'Yes', value: 'yes' },
  { label: 'No', value: 'no' }
] as const;

// Departure date filter options for room allocation filtering
export const ROOM_ALLOCATION_DEPARTURE_DATE_FILTER_OPTIONS = [
  { label: 'Pick Date and Time', value: { min: new Date().toISOString(), max: new Date().toISOString() } },
] as const;

// Return terminal options for room allocation filtering
export const ROOM_ALLOCATION_RETURN_TERMINAL_OPTIONS = [
  { label: 'Domestic', value: 'Domestic' },
  { label: 'International', value: 'International' }
] as const;

// Room allocation filter configuration base structure
export const ROOM_ALLOCATION_FILTER_CONFIG_BASE = [
  {
    key: 'age',
    label: 'Age',
    type: 'checkbox',
    sortable: true,
    filterable: true,
    order: 1,
  },
  {
    key: 'gender',
    label: 'Gender',
    type: 'checkbox',
    sortable: false,
    filterable: true,
    order: 2,
  },
  {
    key: 'departureDatetime',
    label: 'Departure Time',
    type: 'date-time-range',
    sortable: true,
    filterable: true,
    order: 3,
  },
  {
    key: 'noOfHdbs',
    label: 'Number of HDBs',
    type: 'multi',
    sortable: true,
    filterable: true,
    order: 4,
  },
  {
    key: 'preferredRoommate',
    label: 'Preferred Roommate',
    type: 'checkbox',
    sortable: false,
    filterable: true,
    order: 5,
  },
  {
    key: 'rmContact',
    label: 'RM Contact',
    type: 'dropdown',
    sortable: false,
    filterable: true,
    order: 5,
  },
  {
    key: 'city',
    label: 'Location',
    type: 'dropdown',
    sortable: false,
    filterable: true,
    order: 6,
  },
  {
    key: 'pairedStatus',
    label: 'Paired Status',
    type: 'radio',
    sortable: false,
    filterable: true,
    order: 7,
  },
  {
    key: 'returnTravelTerminal',
    label: 'Return Travel Terminal',
    type: 'radio',
    sortable: false,
    filterable: true,
    order: 8,
  }
] as const;

/**
 * Room Inventory Filter Configuration Constants
 */

// Room status configuration for KPIs and status management
export const ROOM_STATUS_CONFIG = [
  { status: ['ALL'], label: 'Rooms', key: 'ALL'},
  { status: [RoomStatus.AVAILABLE], label: 'Available', key:RoomStatus.AVAILABLE  },
  { status: [RoomStatus.PARTIALLY_ALLOTTED], label: 'Partially Occupied', key:RoomStatus.PARTIALLY_ALLOTTED  },
  { status: [RoomStatus.ALLOTTED], label: 'Occupied', key :RoomStatus.ALLOTTED  },
  { status: [RoomStatus.RESERVED], label: 'Reserved', key: RoomStatus.RESERVED  },
  { status: [RoomStatus.ALLOTTED, RoomStatus.PARTIALLY_ALLOTTED], label: 'Allocated Seekers', key: 'ALLOCATED_SEEKERS' },
] as const;

// Age filter options for room inventory filtering
export const ROOM_INVENTORY_AGE_FILTER_OPTIONS = [
  { label: '<=20 years', value: { min: 0, max: 20 } },
  { label: '21-30 years', value: { min: 21, max: 30 } },
  { label: '31-50 years', value: { min: 31, max: 50 } },
  { label: '51-65 years', value: { min: 51, max: 65 } },
  { label: '>65 years', value: { min: 66 } },
] as const;

// Gender filter options for room inventory filtering
export const ROOM_INVENTORY_GENDER_FILTER_OPTIONS = [
  { label: 'Male', value: 'male' },
  { label: 'Female', value: 'female' },
] as const;

// HDB filter options for room inventory filtering
export const ROOM_INVENTORY_HDB_FILTER_OPTIONS = [
  { label: 'Equals', value: { eq: 0 } },
  { label: 'Greater than', value: { minExcluded: 10 } },
  { label: 'Less than', value: { maxExcluded: 11 } },
  { label: 'Within a range', value: { min: 1, max: 10 } },
] as const;

// Roommate preference options for room inventory filtering
export const ROOM_INVENTORY_ROOMMATE_PREFERENCE_OPTIONS = [
  { label: 'Yes', value: 'yes' },
  { label: 'No', value: 'no' }
] as const;

// Paired status options for room inventory filtering
export const ROOM_INVENTORY_PAIRED_STATUS_OPTIONS = [
  { label: 'Yes', value: 'yes' },
  { label: 'No', value: 'no' }
] as const;

// Departure date filter options for room inventory filtering
export const ROOM_INVENTORY_DEPARTURE_DATE_FILTER_OPTIONS = [
  { label: 'Pick Date and Time', value: { min: new Date().toISOString(), max: new Date().toISOString() } }
] as const;

// Return terminal options for room inventory filtering
export const ROOM_INVENTORY_RETURN_TERMINAL_OPTIONS = [
  { label: 'Domestic', value: 'Domestic' },
  { label: 'International', value: 'International' }
] as const;

// Room inventory filter configuration base structure
export const ROOM_INVENTORY_FILTER_CONFIG_BASE = [
  {
    key: 'age',
    label: 'Age',
    type: 'checkbox',
    sortable: true,
    filterable: true,
    order: 1,
  },
  {
    key: 'gender',
    label: 'Gender',
    type: 'checkbox',
    sortable: true,
    filterable: true,
    order: 2,
  },
  {
    key: 'departureDatetime',
    label: 'Departure Time',
    type: 'date-time-range',
    sortable: true,
    filterable: true,
    order: 3,
  },
  {
    key: 'noOfHdbs',
    label: 'Number of HDBs',
    type: 'multi',
    sortable: true,
    filterable: true,
    order: 4,
  },
  {
    key: 'rmContact',
    label: 'RM Contact',
    type: 'dropdown',
    sortable: true,
    filterable: true,
    order: 5,
  },
  {
    key: 'city',
    label: 'Location',
    type: 'dropdown',
    sortable: true,
    filterable: true,
    order: 6,
  },
  {
    key: 'preferredRoommate',
    label: 'Preferred Roommate',
    type: 'checkbox',
    sortable: true,
    filterable: true,
    order: 7,
  },
  {
    key: 'pairedStatus',
    label: 'Paired Status',
    type: 'radio',
    sortable: false,
    filterable: true,
    order: 8,
  },
  {
    key: 'occupancy',
    label: 'Room Occupancy',
    type: 'number',
    sortable: true,
    filterable: true,
    order: 9,
    placeholder: 'Enter room occupancy',
  },
  // {
  //   key: 'floor',
  //   label: 'Floor',
  //   type: 'dropdown',
  //   sortable: true,
  //   filterable: true,
  //   order: 10,
  // },
  {
    key: 'returnTravelTerminal',
    label: 'Return Travel Terminal',
    type: 'radio',
    sortable: false,
    filterable: true,
    order: 10,
  }
] as const;

/**
 * Room Inventory Controller Filter Configuration Constants
 * Used for the main listing page filters in the controller
 */
export const ROOM_INVENTORY_CONTROLLER_FILTERS = [
  {
    key: 'venues',
    label: 'Select Venue',
    type: 'dropdown',
    sortable: false,
    filterable: true,
    order: 1
  },
  {
    key: 'block',
    label: 'Select Block',
    type: 'dropdown',
    sortable: false,
    filterable: true,
    order: 2,
  },
  {
    key: 'floor',
    label: 'Select Floor',
    type: 'dropdown',
    sortable: false,
    filterable: true,
    order: 3,
  }
] as const;