import { ApiProperty } from '@nestjs/swagger';
import { IsEnum, IsNotEmpty, IsOptional, IsEmail } from 'class-validator';
import { LoginTypeEnum } from 'src/common/enum/login-type.enum';

export class ValidateOtpDto {
  @ApiProperty({ enum: LoginTypeEnum })
  @IsEnum(LoginTypeEnum)
  loginType: LoginTypeEnum;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsNotEmpty()
  phoneNumber?: string;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsNotEmpty()
  countryCode?: string;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsEmail()
  email?: string;

  @ApiProperty()
  @IsNotEmpty()
  otp: string;
}
