import { Controller, Post, Body, HttpCode, HttpStatus, Res, Req } from '@nestjs/common';
import { Response } from 'express';
import { AiCommunicationService } from './ai-communication.service';
import { ExtractionInfo } from './dto/create-ai-communication.dto';
import { ApiBearerAuth, ApiResponse, ApiSecurity, ApiTags } from '@nestjs/swagger';
import { handleControllerError } from 'src/common/utils/controller-response-handling';
import { ResponseService } from 'src/common/response-handling/response-handler';

@ApiTags('extract-details')
@Controller('extract-details')
@ApiBearerAuth('Authorization')
@ApiSecurity('userIdAuth')
export class AiCommunicationController {
  constructor(
    private readonly aiCommunicationService: AiCommunicationService,
    private readonly responseService: ResponseService,
  ) {}

  @Post()
  @HttpCode(HttpStatus.OK)
  @ApiResponse({ status: HttpStatus.OK, description: 'File extracted successfully' })
  @ApiResponse({ status: HttpStatus.BAD_REQUEST, description: 'Invalid request' })
  @ApiResponse({ status: HttpStatus.NOT_FOUND, description: 'AI Communication not found' })
  async extractFile(@Body() extractionInfo: ExtractionInfo, @Req() req: any, @Res() res: Response) {
    try {
      const data = await this.aiCommunicationService.analyzeTheDocument(extractionInfo);
      return this.responseService.success(res, 'Data retrieved successfully', { data });
    } catch (error) {
      return await handleControllerError(res, error);
    }
  }
}
