CREATE TYPE public.address_type_enum AS ENUM (
    'billing_address',
    'invoice_address',
    'user_address'
);


CREATE TYPE public.approval_status_enum AS ENUM (
    'pending',
    'approved',
    'rejected',
    'under_review',
    'on_hold'
);

CREATE TYPE public.basic_details_status_enum AS ENUM (
    'draft',
    'pending',
    'waitlisted',
    'completed',
    'rejected',
    'save_as_draft'
);

CREATE TYPE public.communication_status_enum AS ENUM (
    'initiated',
    'success',
    'failed'
);

CREATE TYPE public.communication_type_enum AS ENUM (
    'whatsapp',
    'email'
);

CREATE TYPE public.frequency_enum AS ENUM (
    'weekly',
    'monthly',
    'yearly',
    'one_time'
);

CREATE TYPE public.gender_enum AS ENUM (
    'male',
    'female',
    'other',
    'prefer_not_to_say'
);

CREATE TYPE public.hdb_common_status_enum AS ENUM (
    'draft',
    'active',
    'inactive',
    'published',
    'archived'
);

CREATE TYPE public.hdb_option_type_enum AS ENUM (
    'string',
    'number',
    'boolean',
    'date',
    'timestamp',
    'image',
    'file',
    'object',
    'enum',
    'color',
    'primarybutton',
    'secondarybutton'
);

CREATE TYPE public.id_type_enum AS ENUM (
    'passport',
    'aadhar',
    'driving_license',
    'voter_id',
    'pan_card',
    'Passport',
    'Aadhar',
    'Voter id',
    'Driving license',
    'Pan card'
);

CREATE TYPE public.invoice_status_enum AS ENUM (
    'draft',
    'invoice_pending',
    'invoice_completed',
    'save_as_draft'
);


CREATE TYPE public.invoice_type_enum AS ENUM (
    'online',
    'offline'
);


CREATE TYPE public.mode_of_operation_enum AS ENUM (
    'online',
    'offline',
    'hybrid'
);

CREATE TYPE public.online_type_enum AS ENUM (
    'meeting',
    'webinar',
    'live_stream',
    'NA'
);


CREATE TYPE public.payment_mode_enum AS ENUM (
    'online',
    'offline',
    'Cheque',
    'Direct bank transfer (NEFT/RTGS)',
    'Card swipe',
    'Cash',
    'Online (Through Razorpay)'
);


CREATE TYPE public.payment_status_enum AS ENUM (
    'draft',
    'online_pending',
    'online_completed',
    'offline_pending',
    'offline_completed',
    'save_as_draft'
);


CREATE TYPE public.program_status_enum AS ENUM (
    'draft',
    'active',
    'registration_open',
    'registration_closed',
    'completed',
    'cancelled',
    'published',
    'internal'
);


CREATE TYPE public.registration_level_enum AS ENUM (
    'program',
    'session',
    'both'
);

CREATE TYPE public.registration_status_enum AS ENUM (
    'draft',
    'pending_approval',
    'waitlisted',
    'completed',
    'cancelled',
    'pending',
    'rejected',
    'offline_pending',
    'on_hold',
    'save_as_draft',
    'attempted'
);


CREATE TYPE public.session_status_enum AS ENUM (
    'scheduled',
    'active',
    'completed',
    'cancelled',
    'postponed',
    'draft'
);


CREATE TYPE public.tds_applicability_enum AS ENUM (
    'base_only',
    'base_plus_tax'
);



CREATE TYPE public.travel_status_enum AS ENUM (
    'draft',
    'pending',
    'completed',
    'save_as_draft'
);


CREATE TYPE public.travel_type_enum AS ENUM (
    'flight',
    'own_transport',
    'city_pickup',
    'city_drop',
    'city_pick_up'
);


CREATE TYPE public.tshirt_size_enum AS ENUM (
    'XS',
    'S',
    'M',
    'L',
    'XL',
    'XXL',
    'XXXL'
);


CREATE TYPE public.user_session_status_enum AS ENUM (
    'initiated',
    'validated',
    'logged_out',
    'expired',
    'failed'
);

CREATE TYPE public.user_type_enum AS ENUM (
    'Seeker',
    'Org',
    'AI',
    'System'
);

CREATE TYPE public.room_status_enum AS ENUM (
    'AVAILABLE',
    'PARTIALLY_ALLOTTED',
    'ALLOTTED',
    'RESERVED'
);

CREATE TYPE public.room_category_enum AS ENUM (
    'general',
    'physically_challenged',
    'senior_citizens',
    'children'
);