const admin = require("firebase-admin"); // Import firebase admin module
import { Socket } from "socket.io"; // Import socket.io module
import { firebaseAccountCredentials } from "../common/constants"; // Import the firebaseAccountCredentials
import { createLogger } from "../utils/winstonLogger"; // Import the logger function
const logger = createLogger; // logger initialized
/**
 * Initialize Firebase Admin SDK as shown in step 2
 */
export const authenticateSocket = async (
  socket: Socket,
  next: (err?: any) => void
) => {
  try {
    logger.info("Authentication initialized");
    const firebaseToken = (socket.handshake.headers.token as string) || "";
    const userId = (socket.handshake.headers.userid as string) || null;
    logger.info(
      `token details from socket, userid ${userId} and firebasetoken ${firebaseToken}}`
    );
    if (!userId) {
      logger.error(`WebSocket error: userId not present`);
      // throw new Error("Bad request, userid is missing in headers.");
      return next(new Error("Bad request, userid is missing in headers."));
    }
    if (!firebaseToken) {
      logger.error(`WebSocket error: firebasetoken not present`);
      // throw new Error("Unauthorized, Firebase token is missing.");
      return next(new Error("Unauthorized, Firebase token is missing."));
    }

    // Initialize Firebase Admin SDK only if not initialized
    if (!admin.apps.length) {
      logger.info(`firebaseAccountCredentials details initialized`);
      admin.initializeApp({
        credential: admin.credential.cert(firebaseAccountCredentials),
      });
    }
    if (userId !== "zoomAdmin") {
    const decodedToken = await admin.auth().verifyIdToken(firebaseToken);
      // decoded the token and verifying the userid
      if (decodedToken.uid !== userId) {
        logger.error(`Unauthorized, invalid Firebase token.`);
        // throw new Error("Unauthorized, invalid Firebase token.");
        return next(new Error("Unauthorized, invalid Firebase token."));
      }
    }
    logger.info(`Websocket Data: Authorized`);

    next();
  } catch (error) {
    logger.error(`Authentication error: ${error}`);
    socket.emit("error", {
      message: "Internal server error during authentication.",
    });
    return next(new Error("Internal server error during authentication."));
  }
};
